import random
import string

def generate_block(left, top,  width, height, color, text):
    return f"""
    <div style="position: absolute; left: {left}%; top: {top}%; width: {width}%; height: {height}%; background-color: {color};">
        {text}
    </div>
"""


def generate_circle(left, top, diameter, color, text):
    return f"""
    <div style="position: absolute; left: {left}%; top: {top}%; width: {diameter}%; height: {diameter}%; background-color: {color}; border-radius: 50%; text-align:center;">
        <p style="margin: 0; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">{text}</p>
    </div>
"""


def generate_html_doc(title, elements):
    return f"""
<!DOCTYPE html>
<html>
  <head>
    <title>{title}</title>
  </head>
  <body>
    {elements}
  </body>
</html>
"""


with open('text_source.txt') as f:
    text_source = f.read()
words = text_source.split(" ")


def get_random_text(n_words=1):
    start_index = random.randint(0, len(words) - n_words)
    return " ".join(words[start_index:start_index + n_words])
    

def generate_random_circle():
    return generate_circle(
        random.randint(0, 80),
        random.randint(0, 80),
        random.randint(10, 30),
        f'#{random.randint(0, 0xFFFFFF):06X}',
        get_random_text()
    )

def generate_random_block():
    return generate_block(
        random.randint(0, 80),
        random.randint(0, 80),
        random.randint(10, 30),
        random.randint(10, 30),
        f'#{random.randint(0, 0xFFFFFF):06X}',
        get_random_text()
    )

def generate_random_html():
    elements = ""
    circles = 0
    blocks = 0
    for _ in range(random.randint(1, 6)):
        if random.randint(0, 1) == 0:
            elements += generate_random_block()
            blocks += 1
        else:
            elements += generate_random_circle()
            circles += 1
    return generate_html_doc(f"{circles} Circles, {blocks} Blocks", elements)

if __name__ == '__main__':
    with open('', 'w') as f:
        f.write(generate_random_html())